// Get a distance from 2 picked points or a numeric input. This is used for
// offset and fillet.

function GetDistance( factory, factoryinputindex, inputcontrolname, options )
{
	var allowzero = options ? options.allowzero : false;
	var eventhandler = options ? options.eventhandler : false;
	var skipinitialization = options ? options.skipinitialization : false;

	var pointpicker = moi.ui.createPointPicker();
	pointpicker.disableSnapToBasePt = true;

	var HaveDistance = false;
	
	// Initialize the distance to any value that was persisted in the input UI control.
	
	try
	{
		var StartDistance = moi.ui.commandUI[inputcontrolname].value;
		if ( StartDistance != undefined && (StartDistance > 0.0 || (allowzero && StartDistance >= 0.0)) )
		{
			HaveDistance = true;
			
			if ( !skipinitialization )
			{
				factory.setInput( factoryinputindex, StartDistance );
				factory.update();
			}
		}
	}
	catch(e)
	{
	}
	
	// Now we'll loop through and keep picking points. Points are grouped into 2 - a
	// distance is created on each second pick.
	
	var HaveBasePt = false;
	var BasePt = null;
	
	while( 1 )
	{
		pointpicker.disableBasePt = !HaveBasePt;
	
		if ( !pointpicker.waitForEvent() )
			return false;
		
		// We finish once the "Done" button is pushed.	
		if ( pointpicker.event == 'done' )
			break;

		if ( pointpicker.event == 'finished' )
		{
			pointpicker.clearBindings();
					
			if ( !HaveBasePt )
			{
				// If we don't have a base point, then the just picked point becomes
				// the base point.
			
				BasePt = pointpicker.pt;
				HaveBasePt = true;
				
				moi.ui.commandUI.g_BasePt = BasePt;
				pointpicker.bindFunc( moi.ui.commandUI.OnGetDistancePoint );
			}
			else
			{
				// If we already had a base point, then the just picked point defines
				// a new distance.
			
				var OtherPt = pointpicker.pt;
				var dist = moi.vectorMath.distance( BasePt, OtherPt );
				
				if ( dist > 0.0 || (allowzero && dist >= 0.0) )
				{
					HaveDistance = true;
					
					moi.ui.commandUI[inputcontrolname].value = dist;
					factory.setInput( factoryinputindex, dist );
					factory.update();
				}
				
				HaveBasePt = false;
				moi.ui.clearPickedPoints();
			}
		}
		else if ( pointpicker.event == inputcontrolname )
		{
			// The distance was entered directly through the input control.
			var dist = moi.ui.commandUI[inputcontrolname].value;
			
			if ( dist > 0.0 || (allowzero && dist >= 0.0) )
			{
				HaveDistance = true;
				factory.setInput( factoryinputindex, dist );
				factory.update();
			}
		}
		
		if ( eventhandler && eventhandler( pointpicker ) )
			return true;
	}
	
	if ( !HaveDistance )
		return false;
		
	return true;
}
